﻿using System;

namespace Hims.Shared.EntityModels
{
    
    /// <summary>
    /// The encounter.
    /// </summary>
    public class EmergencyEncounterModel
    {
        /// <summary>
        /// Gets or sets the emergency encounter id.
        /// </summary>
        public int EmergencyEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }
        /// <summary>
        /// Get or sets patient Id
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the abdomen.
        /// </summary>
        public string? EmergencyTriage { get; set; }

        /// <summary>
        /// Gets or sets the additional Labs.
        /// </summary>
        public string? NursingERForm { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public string? UMRNo { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public string? AppointmentTime { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public string? PatientName { get; set; }
           

    }
}