﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The scan document.
    /// </summary>
    public class ScanDocumentModel
    {
        /// <summary>
        /// Gets or sets the scan document id.
        /// </summary>
        public int ScanDocumentId { get; set; }

        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public int BookScanAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the uploaded by.
        /// </summary>
        public int UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the document name.
        /// </summary>
        public string DocumentName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the content type.
        /// </summary>
        public string ContentType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        public float Size { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the document url.
        /// </summary>
        public string DocumentUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        public DateTime UploadedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether IsRead.
        /// </summary>
        public bool IsRead { get; set; }
        public int? PatientId { get; set; }

    }
}
