﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    /// <summary>
    /// The vital model.
    /// </summary>
    public class VitalsModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public string? AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public string? AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the height.
        /// </summary>
        public string? Vitals { get; set; }

        /// <summary>
        /// Gets or sets the height.
        /// </summary>
        public Vital? Vital { get; set; }

        /// <summary>
        /// Gets or sets the height.
        /// </summary>
        public int? TotalItems { get; set; }

    }

    /// <summary>
    /// The vital model.
    /// </summary>
    public class Vital
    {
        /// <summary>
        /// Gets or sets the height.
        /// </summary>
        public string? Height { get; set; }

        /// <summary>
        /// Gets or sets the weight.
        /// </summary>
        public string? Weight { get; set; }

        /// <summary>
        /// Gets or sets the weightMsrmtMob.
        /// </summary>
        public string? WeightMsrmtMob { get; set; }

        /// <summary>
        /// Gets or sets the heightMsrmtMob.
        /// </summary>
        public string? HeightMsrmtMob { get; set; }

        /// <summary>
        /// Gets or sets the bmi.
        /// </summary>
        public string? Bmi { get; set; }

        /// <summary>
        /// Gets or sets the bmiMsrmt.
        /// </summary>
        public string? BmiMsrmt { get; set; }

        /// <summary>
        /// Gets or sets the weightMsrmt.
        /// </summary>
        public string? WeightMsrmt { get; set; }

        /// <summary>
        /// Gets or sets the temparature.
        /// </summary>
        public string? Temperature { get; set; }

        /// <summary>
        /// Gets or sets the hr.
        /// </summary>
        public string? Hr { get; set; }

        /// <summary>
        /// Gets or sets the hrMsrmt.
        /// </summary>
        public string? HrMsrmt { get; set; }

        /// <summary>
        /// Gets or sets the respiration.
        /// </summary>
        public string? Respiratory { get; set; }

        /// <summary>
        /// Gets or sets the respirationMsrmt.
        /// </summary>
        public string? RespirationMsrmt { get; set; }

        /// <summary>
        /// Gets or sets the pulse.
        /// </summary>
        public string? PulseOximetry { get; set; }

        /// <summary>
        /// Gets or sets the pulseMsrmt.
        /// </summary>
        public string? PulseMsrmt { get; set; }

        /// <summary>
        /// Gets or sets the systolicBp.
        /// </summary>
        public string? SystolicBp { get; set; }

        /// <summary>
        /// Gets or sets the systolicBpMsrmt.
        /// </summary>
        public string? SystolicBpMsrmt { get; set; }

        /// <summary>
        /// Gets or sets the diastolicBp.
        /// </summary>
        public string? DiastolicBp { get; set; }

        /// <summary>
        /// Gets or sets the diastolicBpMsrmt.
        /// </summary>
        public string? DiastolicBpMsrmt { get; set; }

        /// <summary>
        /// Gets or sets the fasting glucose.
        /// </summary>
        public string? FastingGlucose { get; set; }

        /// <summary>
        /// Gets or sets the random glucose.
        /// </summary>
        public string? RandomGlucose { get; set; }

        /// <summary>
        /// Gets or sets the hba1c.
        /// </summary>
        public string? Hba1c { get; set; }

        /// <summary>
        /// Gets or sets the t3.
        /// </summary>
        public string? T3 { get; set; }

        /// <summary>
        /// Gets or sets the t4.
        /// </summary>
        public string? T4 { get; set; }

        /// <summary>
        /// Gets or sets the tsh.
        /// </summary>
        public string? TSH { get; set; }
    }
}
