﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.ChargeModule
{
    public class DoctorSpecializationChargeModuleDetailsModel
    {
        /// <summary>
        /// Gets or sets the doctor specialization charge module details identifier.
        /// </summary>
        /// <value>
        /// The doctor specialization charge module details identifier.
        /// </value>
        public long? DoctorSpecializationChargeModuleDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the specialization identifier.
        /// </summary>
        /// <value>
        /// The specialization identifier.
        /// </value>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the consultation type identifier.
        /// </summary>
        /// <value>
        /// The consultation type identifier.
        /// </value>
        public int? ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the reference ids.
        /// </summary>
        /// <value>
        /// The reference ids.
        /// </value>
        public string ReferenceIds { get; set; }

        /// <summary>
        /// Gets or sets the reference identifier.
        /// </summary>
        /// <value>
        /// The reference identifier.
        /// </value>
        public int? ReferenceId { get; set; }

        /// <summary>
        /// Gets or sets the charge module category identifier.
        /// </summary>
        /// <value>
        /// The charge module category identifier.
        /// </value>
        public int? DoctorSpecializationChargeModuleCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        /// <value>
        /// The amount.
        /// </value>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge category.
        /// </summary>
        /// <value>
        /// The name of the charge category.
        /// </value>
        public string ChargeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the module.
        /// </summary>
        /// <value>
        /// The name of the module.
        /// </value>
        public string ModuleName { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ChargeModuleDetailsModel"/> is default.
        /// </summary>
        /// <value>
        ///   <c>true</c> if default; otherwise, <c>false</c>.
        /// </value>
        public bool Default { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int? ModulesMasterId { get; set; }

        /// <summary>
        /// Gets or sets the charge module template identifier.
        /// </summary>
        /// <value>
        /// The charge module template identifier.
        /// </value>
        public int? ChargeModuleTemplateId { get; set; }

        /// <summary>
        /// Gets or sets the follow up days limit.
        /// </summary>
        /// <value>
        /// The follow up days limit.
        /// </value>
        public int? FollowUpDaysLimit { get; set; }

        /// <summary>
        /// Gets or sets the follow up days.
        /// </summary>
        /// <value>
        /// The follow up days.
        /// </value>
        public int? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the charges.
        /// </summary>
        /// <value>
        /// The charges.
        /// </value>
        public List<DoctorSpecializationChargeModuleDetailsModel> Charges { get; set; }
    }
}
