﻿using System.Text.Json.Serialization;

namespace Hims.Shared.UserModels.Common
{
    /// <summary>
    /// The common response.
    /// </summary>
    public class IdModel
    {
        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public int Id { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }
        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by .
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the  comments.
        /// </summary>
        public int? RoleId { get; set; }

        ///// <summary>
        ///// Gets or sets the modified by name.
        ///// </summary>
        ///// <value>
        ///// The created by.
        ///// </value>
        //public int ModifiedByName { get; set; }
        /// <summary>
        /// gets or sets the admission id
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the  Location Id.
        /// </summary>
        public int? LocationId { get; set; }


    }
}
