﻿using System;

namespace Hims.Shared.UserModels.Common
{
    /// <summary>
    /// 
    /// </summary>
    public class RegistrationBillModel
    {
        /// <summary>
        /// Gets or sets the patient registration detail identifier.
        /// </summary>
        /// <value>
        /// The patient registration detail identifier.
        /// </value>      
        public int PatientRegistrationDetailId { get; set; }

        /// <summary>
        /// Gets or sets the patient registration charge identifier.
        /// </summary>
        /// <value>
        /// The patient registration charge identifier.
        /// </value>
        public double Charge { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the pay type identifier.
        /// </summary>
        /// <value>
        /// The pay type identifier.
        /// </value>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the pay type.
        /// </summary>
        /// <value>
        /// The name of the pay type.
        /// </value>
        public string? PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        /// <value>
        /// The mobile.
        /// </value>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public DateTime? FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }


        /// <summary>
        /// Gets or sets the receipt  identifier.
        /// </summary>
        /// <value>
        /// The receipt identifier.
        /// </value>
        public int? ReceiptId { get; set; }

        /// <summary>
        /// Gets or sets the payment detail.
        /// </summary>
        /// <value>
        /// The payment detail.
        /// </value>
        public string? PaymentDetails{ get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string FirstName { get; set; }
        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string MiddleName { get; set; }
        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string LastName { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
       
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the receipt  identifier.
        /// </summary>
        /// <value>
        /// The receipt identifier.
        /// </value>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the patient registration charge identifier.
        /// </summary>
        /// <value>
        /// The patient registration charge identifier.
        /// </value>
        public decimal Amount { get; set; }

        /// <summary>
        /// Gets or sets the patient registration charge identifier.
        /// </summary>
        /// <value>
        /// The patient registration charge identifier.
        /// </value>
        public decimal Discount { get; set; }
    }
}
