﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.DynamicDashboard.Config
{
    /// <summary>
    /// 
    /// </summary>
    public class InsertModel
    {
        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the account identifier.
        /// </summary>
        /// <value>
        /// The account identifier.
        /// </value>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the dashboard configuration master identifier.
        /// </summary>
        /// <value>
        /// The dashboard configuration master identifier.
        /// </value>
        public int? DashboardConfigMasterId { get; set; }

        /// <summary>
        /// Gets or sets the rows.
        /// </summary>
        /// <value>
        /// The rows.
        /// </value>
        public List<InsertModelHelper> Rows { get; set; }
    }

    /// <summary>
    /// 
    /// </summary>
    public class InsertModelHelper
    {
        /// <summary>
        /// Gets or sets the dashboard widget identifier.
        /// </summary>
        /// <value>
        /// The dashboard widget identifier.
        /// </value>
        public int DashboardWidgetId { get; set; }

        /// <summary>
        /// Gets or sets the row number.
        /// </summary>
        /// <value>
        /// The row number.
        /// </value>
        public int RowNumber { get; set; }

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        /// <value>
        /// The size.
        /// </value>
        public int Size { get; set; }

        /// <summary>
        /// Gets or sets the sequence number.
        /// </summary>
        /// <value>
        /// The sequence number.
        /// </value>
        public int SequenceNumber { get; set; }

        /// <summary>
        /// Gets or sets the default values.
        /// </summary>
        /// <value>
        /// The default values.
        /// </value>
        public string DefaultValues { get; set; }
    }
}
