﻿#nullable enable
using System;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The coupon filter model.
    /// </summary>
    public class IndentInventoryFilterModel
    {
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string? PharmacyBillNumber { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public string? DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public string? ProductName { get; set; }

        /// <summary>
        /// Gets or sets the is final report.
        /// </summary>
        public bool? isFinalReport { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy bill type
        /// </summary>
        public bool? pharmacyBillType { get; set; }


        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the category id.
        /// </summary>
        public int? CategoryId { get; set; }

        /// <summary>
        /// Gets or sets the batch no.
        /// </summary>
        public string? BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; } = string.Empty;
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string ProviderName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the paid via.
        /// </summary>
        public int? PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the retailname.
        /// </summary>
        public string? RetailName { get; set; }
        /// <summary>
        /// Gets or sets the retail pharmacy store id.
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the bill amount.
        /// </summary>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the cash total.
        /// </summary>
        public double? CashTotal { get; set; }

        /// <summary>
        /// Gets or sets the card total.
        /// </summary>
        public double? CardTotal { get; set; }

        /// <summary>
        /// Gets or sets the gross total.
        /// </summary>
        public double? GrossTotal { get; set; }

        /// <summary>
        /// Gets or sets the gst total.
        /// </summary>
        public double? GstTotal { get; set; }

        /// <summary>
        /// Gets or sets the gst total.
        /// </summary>
        public string? SaleDate { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the indent to.
        /// </summary>
        public string? IndentTo { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int? ProductId { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int? RequestedBy { get; set; }

        /// <summary>
        /// Gets or sets the product id.
        /// </summary>
        public int? ApprovedBy { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the payType id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string PaymentNumber { get; set; }

     
    }
}
