﻿using System;
namespace Hims.Shared.UserModels.Labs
{
    /// <summary>
    /// The lab technician approval model.
    /// </summary>
    public class LabTechnicianApprovalModel
    {

        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int? NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int? NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int? LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking status identifier.
        /// </summary>
        /// <value>
        /// The lab booking status identifier.
        /// </value>
        public int? LabBookingStatusId { get; set; }
        public int? HoldBy { get; set; }
        public int? UnHoldBy { get; set; }
        public int? TechnicianId { get; set; }

        public string Comment { get; set; }
        public string HoldComments { get; set; }
        public string UnHoldComments { get; set; }
        public string TechnicianComment { get; set; }
        public string RequisitionNumber { get; set; }
        public string BilledLocation { get; set; }
        public string SampleCollectionLocation { get; set; }
        public string SampleCollectedBy { get; set; }
        public string Status { get; set; }
        public string TestName { get; set; }
        public string TestCode { get; set; }
        public string PatientName { get; set; }
        public string Mobile { get; set; }
        public string DoctorName { get; set; }
        public string EmployeeName { get; set; }
        public string DepartmentName { get; set; }
        public string TechnicianName { get; set; }
        public bool Emergency { get; set; }

        public DateTime? TechnicianVerificationDate { get; set; }
        public DateTime? BookedDate { get; set; }
        public DateTime? CollectionDate { get; set; }
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the type of the booking.
        /// </summary>
        /// <value>
        /// The type of the booking.
        /// </value>
        public string BookingType { get; set; }
    }
}
