﻿namespace Hims.Shared.UserModels.Menu
{
    /// <summary> The chat.</summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the main page.
        /// </summary>
        /// <value>
        /// The main page.
        /// </value>
        public string MainPage { get; set; }

        /// <summary>
        /// Gets or sets the menu identifier.
        /// </summary>
        /// <value>
        /// The menu identifier.
        /// </value>
        public int MenuId { get; set; }

        /// <summary>
        /// Gets or sets the sub page.
        /// </summary>
        /// <value>
        /// The sub page.
        /// </value>
        public string SubPage { get; set; }

        /// <summary>
        /// Gets or sets the category.
        /// </summary>
        /// <value>
        /// The category.
        /// </value>
        public string Category { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        /// <value>
        /// The display name.
        /// </value>
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the URL.
        /// </summary>
        /// <value>
        /// The URL.
        /// </value>
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the general classes.
        /// </summary>
        /// <value>
        /// The general classes.
        /// </value>
        public string GeneralClasses { get; set; }

        /// <summary>
        /// Gets or sets the icon classes.
        /// </summary>
        /// <value>
        /// The icon classes.
        /// </value>
        public string IconClasses { get; set; }

        /// <summary>
        /// Gets or sets the menu type identifier.
        /// </summary>
        /// <value>
        /// The menu type identifier.
        /// </value>
        public int? MenuTypeId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int? Priority { get; set; }

        /// <summary>
        /// Gets or sets the count.
        /// </summary>
        /// <value>
        /// The count.
        /// </value>
        public int? Count { get; set; }

        /// <summary>
        /// Gets or sets the name of the menu type.
        /// </summary>
        /// <value>
        /// The name of the menu type.
        /// </value>
        public string MenuTypeName { get; set; }

        public string? EncounterKey { get; set; }

        public int? ButtonsCount { get; set; }
    }
}