﻿using System;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.NurseShift
{
    /// <summary>
    /// The basic bed Nurse Shift Map.
    /// </summary>
    public class InsertModel
    {
        /// <summary>
        /// Gets or sets the nurse identifier.
        /// </summary>
        /// <value>
        /// The nurse identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the nurse identifier.
        /// </summary>
        /// <value>
        /// The nurse identifier.
        /// </value>
        public int NurseId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the shifts.
        /// </summary>
        /// <value>
        /// The shifts.
        /// </value>
        public List<InsertShiftModel> Shifts { get; set; }
    }

    /// <summary>
    /// The basic bed Nurse Shift Map.
    /// </summary>
    public class InsertShiftModel
    {
        /// <summary>
        /// Gets or sets the bed ids.
        /// </summary>
        /// <value>
        /// The bed ids.
        /// </value>
        public List<int> BedIds { get; set; }

        /// <summary>
        /// Gets or sets the shift identifier.
        /// </summary>
        /// <value>
        /// The shift identifier.
        /// </value>
        public int ShiftId { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public DateModel FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public DateModel ToDate { get; set; }
    }
}