﻿namespace Hims.Shared.UserModels.PediatricGraphs
{
    /// <summary>
    /// The pediatric base display model.
    /// </summary>
    public class PediatricBaseDisplayModel
    {
        /// <summary>
        /// Gets or sets the pediatric chart type identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart type identifier.
        /// </value>
        public int PediatricChartTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pediatric chart authority identifier.
        /// </summary>
        /// <value>
        /// The pediatric chart authority identifier.
        /// </value>
        public int PediatricChartAuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the authority.
        /// </summary>
        /// <value>
        /// The name of the authority.
        /// </value>
        public string AuthorityName { get; set; }
    }
}
