﻿using System;

namespace Hims.Shared.UserModels.Pharmacy
{
    /// <summary>
    /// The pharmacy purchase return bill model.
    /// </summary>
    public class PharmacyPurchaseReturnBillModel
    {
        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary> 
        public double TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase detail id.
        /// </summary>
        public int PharmacyPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase header id.
        /// </summary>
        public int PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        public int ReturnQuantity { get; set; }
        
        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public int TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the ExpiryDate.
        /// </summary>
        public DateTime ReturnDate { get; set; }

        /// <summary>
        /// Gets or sets the ExpiryDate.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the Indent Name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the IndentByrole Name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the BatchNumber
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the supplier name .
        /// </summary>
        public string SupplierName { get; set; }
        /// <summary>
        /// Gets or sets the supplier name .
        /// </summary>
        public string WareHouseName { get; set; }
    }
}
