﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The pharmacy bill model.
    /// </summary>
    public class PharmacyBillModel
    {

        /// <summary>
        /// Gets or sets the pharmacy purchase header id.
        /// </summary>
        public int PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the bill amount.
        /// </summary>
        public double BillAmount { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public float Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public float Free { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax per item.
        /// </summary>
        public double? TaxPerItem { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double? TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the total net amount.
        /// </summary>
        public double TotalNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the taxes.
        /// </summary>
        public double Taxes { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the over all amount.
        /// </summary>
        public double OverallAmount { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase detail id.
        /// </summary>
        public int PharmacyPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product  id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string SupplierName { get; set; }
    }
}
