﻿namespace Hims.Shared.UserModels.PharmacyRequest
{
    using System;

    /// <summary>
    /// The pharmacy issue display model.
    /// </summary>
    public class PharmacyIssueDisplayModel
    {
        /// <summary>
        /// Gets or sets the pharmacy issue header id.
        /// </summary>
        public int PharmacyIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent header id.
        /// </summary>
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy issue detail id.
        /// </summary>
        public int PharmacyIssueDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the retail stock id.
        /// </summary>
        public int RetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall gst.
        /// </summary>
        public double OverallGst { get; set; }

        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double OverallTotal { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the gst percentage.
        /// </summary>
        public double GstPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the gst amount.
        /// </summary>
        public double GstAmount { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the retail.
        /// </summary>
        /// <value>
        /// The name of the retail.
        /// </value>
        public string RetailName { get; set; }
    }
}
