﻿#nullable enable
namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The provider registration request.
    /// </summary>
    public class ProviderRegistrationModel
    {
        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        public string FriendlyName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        public string ProviderNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the friendly name.
        /// </summary>
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets age.
        /// </summary>
        public short Age { get; set; }

        /// <summary>
        /// Gets or sets the country.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Username { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the password.
        /// </summary>
        public string Password { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether is agreed.
        /// </summary>
        public bool IsAgreed { get; set; }
    }
}
