﻿namespace Hims.Shared.UserModels.Scan.ScanTest
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The request indent header model.
    /// </summary>
    public class ScanTestInsertModel
    {
        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        public int ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the scan test name.
        /// </summary>
        public string ScanTestName { get; set; }

        /// <summary>
        /// Gets or sets the scan test code.
        /// </summary>
        public string ScanTestCode { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public decimal Duration { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }
        
        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the location ids.
        /// </summary>
        /// <value>
        /// The location ids.
        /// </value>
        public string LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationNames { get; set; }



        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the Scan Sub Classification Id.
        /// </summary>
        public int? ScanSubClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the test sub category.
        /// </summary>
        public int? ScanClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<ScanChargesModel> Charges { get; set; }
    }

    /// <summary>
    /// The request indent product model.
    /// </summary>
    public class ScanChargesModel
    {

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }


        /// <summary>
        /// Gets or sets the location ids.
        /// </summary>
        /// <value>
        /// The location ids.
        /// </value>
        public string LocationId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the charge category name.
        /// </summary>
        public string ChargeCategoryName { get; set; }
    }
}
