﻿using Hims.Shared.UserModels.Laboratory;
using Hims.Shared.UserModels.Labs;
using System.Collections.Generic;

namespace Hims.Shared.UserModels.ServiceOrder
{
    /// <summary> The chat.</summary>
    public class OverAllViewModel
    {
        /// <summary>
        /// Gets or sets the no of days.
        /// </summary>
        /// <value>
        /// The no of days.
        /// </value>
        public int NoOfDays { get; set; }

        public string ModuleTypeName { get; set; }

        /// <summary>
        /// Gets or sets the bed cost.
        /// </summary>
        /// <value>
        /// The bed cost.
        /// </value>
        public double BedCost { get; set; }

        /// <summary>
        /// Gets or sets the doctor cost.
        /// </summary>
        /// <value>
        /// The doctor cost.
        /// </value>
        public double DoctorCost { get; set; }

        /// <summary>
        /// Gets or sets the covid cost.
        /// </summary>
        /// <value>
        /// The covid cost.
        /// </value>
        public double CovidCost { get; set; }

        /// <summary>
        /// Gets or sets the general records.
        /// </summary>
        /// <value>
        /// The general records.
        /// </value>
        public IEnumerable<ViewModel> GeneralRecords { get; set; }

        /// <summary>
        /// Gets or sets the general records.
        /// </summary>
        /// <value>
        /// The general records.
        /// </value>
        public IEnumerable<SurgeryViewModel> SurgeryServiceRecords { get; set; }

        /// <summary>
        /// Gets or sets the lab services.
        /// </summary>
        /// <value>
        /// The lab services.
        /// </value>
        public IEnumerable<AdmissionNewLabsModel> LabServices { get; set; }

        /// <summary>
        /// Gets or sets the lab services.
        /// </summary>
        /// <value>
        /// The lab services.
        /// </value>
        public IEnumerable<ScanViewModel> ScanServiceRecords { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent records.
        /// </summary>
        /// <value>
        /// The pharmacy indent records.
        /// </value>
        public IEnumerable<PharmacyIndent.ViewModel> PharmacyIndentRecords { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent records.
        /// </summary>
        /// <value>
        /// The pharmacy indent records.
        /// </value>
        public IEnumerable<PackageModuleModel> PackageRecords { get; set; }

        /// <summary>
        /// Gets or sets the room charge category identifier.
        /// </summary>
        /// <value>
        /// The room charge category identifier.
        /// </value>
        public int RoomChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge category.
        /// </summary>
        /// <value>
        /// The name of the charge category.
        /// </value>
        public string ChargeCategoryName { get; set; }
    }
}
