﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.ServiceOrder
{
    using System;
    using Dapper.Attributes;

    /// <summary> The chat.</summary>
    public class UpdateModel
    {
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Creates new records.
        /// </summary>
        /// <value>
        /// The new records.
        /// </value>
        public InsertModel NewRecords { get; set; }

        /// <summary>
        /// Gets or sets the deleted records.
        /// </summary>
        /// <value>
        /// The deleted records.
        /// </value>
        public List<int> DeletedRecords { get; set; }

        /// <summary>
        /// Gets or sets the deleted lab records.
        /// </summary>
        /// <value>
        /// The deleted lab records.
        /// </value>
        public List<int> DeletedLabServices { get; set; }

        /// <summary>
        /// Gets or sets the deactivate lab booking header records.
        /// </summary>
        /// <value>
        /// The deleted lab records.
        /// </value>
        public List<int> DeletedLabBookingHeaderIds { get; set; }

        /// <summary>
        /// Gets or sets the deleted packages.
        /// </summary>
        /// <value>
        /// The deleted packages.
        /// </value>
        public List<int> DeletedPackages { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int? ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the lab service identifier.
        /// </summary>
        /// <value>
        /// The lab service identifier.
        /// </value>
        public int? LabServiceId { get; set; }

        public bool? ReceiptSaving { get; set; }

        /// <summary>
        /// Gets or sets the deleted records.
        /// </summary>
        /// <value>
        /// The deleted records.
        /// </value>
        public List<int> DeletedSurgeryServices { get; set; }

        /// <summary>
        /// Gets or sets the deleted scan services.
        /// </summary>
        public List<int> DeletedScanServices { get; set; }
    }
}
