﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels
{
    /// <summary>
    /// The WhatsAppMessageModel.
    /// </summary>
    public class WhatsAppMessageModel
    {
        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        /// <value>
        /// The patient mobile.
        /// </value>
        public string PatientMobile { get; set; }
        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }
        /// <summary>
        /// Gets or sets the receptionist.
        /// </summary>
        /// <value>
        /// The receptionist.
        /// </value>
        public string Receptionist { get; set; }
        /// <summary>
        /// Gets or sets the name of the doctor.
        /// </summary>
        /// <value>
        /// The name of the doctor.
        /// </value>
        public string DoctorName { get; set; }
        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        /// <value>
        /// The date.
        /// </value>
        public string AppointmentDate { get; set; }
        /// <summary>
        /// Gets or sets the time.
        /// </summary>
        /// <value>
        /// The time.
        /// </value>
        public string AppointmentTime { get; set; }
        /// <summary>
        /// Gets or sets the contact number.
        /// </summary>
        /// <value>
        /// The contact number.
        /// </value>
        public string ContactNumber { get; set; }

        /// <summary>
        /// Gets or sets the otp.
        /// </summary>
        /// <value>
        /// The otp.
        /// </value>
        public string OTPNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the lab.
        /// </summary>
        /// <value>
        /// The name of the lab.
        /// </value>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the lab link.
        /// </summary>
        /// <value>
        /// The lab link.
        /// </value>
        public string LabLink { get; set; }

        /// <summary>
        /// Gets or sets the name of the scan.
        /// </summary>
        /// <value>
        /// The name of the scan.
        /// </value>
        public string ScanName { get; set; }

        /// <summary>
        /// Gets or sets the scan time.
        /// </summary>
        /// <value>
        /// The scan time.
        /// </value>
        public string ScanTime { get; set; }

        /// <summary>
        /// Gets or sets the name of the pharmacy.
        /// </summary>
        /// <value>
        /// The name of the pharmacy.
        /// </value>
        public string PharmacyName { get; set; }

        /// <summary>
        /// Gets or sets the scan date time.
        /// </summary>
        /// <value>
        /// The scan date time.
        /// </value>
        public string ScanDateTime { get; set; }

        /// <summary>
        /// Gets or sets the name of the branch.
        /// </summary>
        /// <value>
        /// The name of the branch.
        /// </value>
        public string BranchName { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        /// <value>
        /// The appointment no.
        /// </value>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the name of the practice.
        /// </summary>
        /// <value>
        /// The name of the practice.
        /// </value>
        public string PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        public string Message { get; set; }
    }
}
