﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The auditLog.
    /// </summary>
    public class AuditLog
    {
        /// <summary>
        /// Gets or sets the auditLog id.
        /// </summary>
        [Key, Identity]
        public int AuditLogId { get; set; }

        /// <summary>
        /// Gets or sets the Log type.
        /// </summary>
        public int LogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the log date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime LogDate { get; set; }

        /// <summary>
        /// Gets or sets the app type.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the user id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the auditLog code.
        /// </summary>
        public string LogDescription { get; set; }

        /// <summary>
        /// Gets or sets the Location id.
        /// </summary>
        public int?  LocationId { get; set; }
    }
}