﻿namespace Hims.Domain.Entities.Labs
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

	/// <summary>
	/// The lab parameter detail.
	/// </summary>
	public class LabParameterDetail
    {
		/// <summary>
		/// Gets or sets the lab parameter detail identifier.
		/// </summary>
		/// <value>
		/// The lab parameter detail identifier.
		/// </value>
		[Key,Identity]
        public long LabParameterDetailId { get; set; }

		/// <summary>
		/// Gets or sets the lab parameter header identifier.
		/// </summary>
		/// <value>
		/// The lab parameter header identifier.
		/// </value>
		public int LabParameterHeaderId { get; set; }

		/// <summary>
		/// Gets or sets the gender.
		/// </summary>
		/// <value>
		/// The gender.
		/// </value>
		public string Gender { get; set; }

		/// <summary>
		/// Gets or sets from age.
		/// </summary>
		/// <value>
		/// From age.
		/// </value>
		public int? FromAge { get; set; }
		
		/// <summary>
		/// Gets or sets the type of from age.
		/// </summary>
		/// <value>
		/// The type of from age.
		/// </value>
		public string FromAgeType { get; set; }

		/// <summary>
		/// Converts to age.
		/// </summary>
		/// <value>
		/// To age.
		/// </value>
		public int? ToAge { get; set; }

		/// <summary>
		/// Converts to agetype.
		/// </summary>
		/// <value>
		/// The type of to age.
		/// </value>
		public string ToAgeType { get; set; }

		/// <summary>
		/// Gets or sets the minimum value.
		/// </summary>
		/// <value>
		/// The minimum value.
		/// </value>
		public double? MinValue { get; set; }

		/// <summary>
		/// Gets or sets the maximum value.
		/// </summary>
		/// <value>
		/// The maximum value.
		/// </value>
		public double? MaxValue { get; set; }

		/// <summary>
		/// Gets or sets the minimum critical value.
		/// </summary>
		/// <value>
		/// The minimum critical value.
		/// </value>
		public double? MinCriticalValue { get; set; }

		/// <summary>
		/// Gets or sets the maximum critical value.
		/// </summary>
		/// <value>
		/// The maximum critical value.
		/// </value>
		public double? MaxCriticalValue { get; set; }

		/// <summary>
		/// Gets or sets the unit identifier.
		/// </summary>
		/// <value>
		/// The unit identifier.
		/// </value>
		public int? UnitId { get; set; }

        /// <summary>
        /// Gets or sets the range text.
        /// </summary>
        /// <value>
        /// The range text.
        /// </value>
        public string? RangeText { get; set; }

	}
}
