﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class OrderPrescriptionValue
    {
        /// <summary>
        /// Gets or sets the value id.
        /// </summary>
        [Key, Identity]
        public int ValueId { get; set; }

        /// <summary>
        /// Gets or sets the order prescription master id.
        /// </summary>
        public int OrderPrescriptionMasterId { get; set; }

        /// <summary>
        /// Gets or sets the value name.
        /// </summary>
        public string ValueName { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        public string Comments { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }


    }
}
