﻿namespace Hims.Domain.Entities.Vendors
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The inventory product request.
    /// </summary>
    [Table("InventoryProductRequest", Schema = "vendors")]
    public class InventoryProductRequest
    {
        /// <summary>
        /// Gets or sets the inventory product request identifier.
        /// </summary>
        /// <value>
        /// The inventory product request identifier.
        /// </value>
        [Key,Identity]
        public int InventoryProductRequestId { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int? PharmacyProductId { get; set; }
        /// <summary>
        /// Gets or sets the name of the request product.
        /// </summary>
        /// <value>
        /// The name of the request product.
        /// </value>
        public string RequestProductName { get; set; }
        /// <summary>
        /// Gets or sets the reason for request.
        /// </summary>
        /// <value>
        /// The reason for request.
        /// </value>
        public string ReasonForRequest { get; set; }
        /// <summary>
        /// Gets or sets the requested quantity.
        /// </summary>
        /// <value>
        /// The requested quantity.
        /// </value>
        public int RequestedQuantity { get; set; }
        /// <summary>
        /// Gets or sets the type of the request.
        /// </summary>
        /// <value>
        /// The type of the request.
        /// </value>
        public string RequestType { get; set; }
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy product request identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product request identifier.
        /// </value>
        public long? PharmacyProductRequestId { get; set; }
        /// <summary>
        /// Gets or sets the rejected by.
        /// </summary>
        /// <value>
        /// The rejected by.
        /// </value>
        public int? RejectedBy { get; set; }
        /// <summary>
        /// Gets or sets the rejected date.
        /// </summary>
        /// <value>
        /// The rejected date.
        /// </value>
        public DateTime? RejectedDate { get; set; }
        /// <summary>
        /// Gets or sets the reject reason.
        /// </summary>
        /// <value>
        /// The reject reason.
        /// </value>
        public string RejectReason { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the document URL.
        /// </summary>
        /// <value>
        /// The document URL.
        /// </value>
        public string DocumentUrl { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }
    }
}
