﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using Hims.Domain.EntityModels;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IChargeCategoryService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ChargeCategoryModel>> FetchAsync(ChargeCategoryModel model);


        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ChargeCategoryModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// 

        Task<int> UpdateAsync(ChargeCategoryModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="chargeTypesId">
        /// The charge id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int chargeCategoryId);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="chargeTypesId">
        /// The charge id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(ChargeCategoryModel model);

        /// <summary>
        /// Fetches the charge category masters asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<ChargeCategoryModel>> FetchChargeCategoryMastersAsync();

        /// <summary>
        /// Fetches the Room charges category  masters wise asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<ChargeCategoryModel>> FetchRoomChargeAsync(ChargeCategoryModel model);
        /// <summary>
        ///insert entry for charges according to category.
        /// </summary>
        /// <returns></returns>
        Task<int> InsertChargetoCategoryAsync(ChargeCategoryModel model);

        /// <summary>
        /// update for cost of charge category.
        /// </summary>
        /// <returns></returns>
        Task<int> UpdateChargetoCategoryAsync(ChargeCategoryModel model);

        /// <summary>
        /// Makes the default charge category asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> MakeDefaultChargeCategoryAsync(ChargeCategoryModel model);
        /// <summary>
        /// The get delete async.
        /// </summary>
      
        /// The charge id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusRoomAsync(ChargeCategoryModel model);
    }
}
