﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.EntityModels;
using Hims.Shared.UserModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class CaseTypeServices : ICaseTypeService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IIdProofService" />
        public CaseTypeServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<int> InsertAsync(CaseTypeModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""CaseType"" where  lower(""CaseTypeName"") = '{model.CaseTypeName.ToLower()}'");
            if (checkIf > 0)
            {
                return -1;
            }
            var caseType = new CaseType
            {
                CaseTypeName = model.CaseTypeName,
                Code = model.Code,
                CreatedBy = model.CreatedBy,
                Active = true,
                CreatedDate = DateTime.Now,
            };
            return await this.unitOfWork.CaseTypes.InsertAsync(caseType);
        }

        /// <inheritdoc/>
        public async Task<int> UpdateAsync(CaseTypeModel model)
        {

            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""CaseType"" where  lower (""CaseTypeName"") = '{model.CaseTypeName.ToLower()}' and ""CaseTypeId"" <> {model.CaseTypeId}");
            if (checkIf > 0)
            {
                return -1;
            }
            var record = await this.unitOfWork.CaseTypes.FindAsync(m => m.CaseTypeId == model.CaseTypeId);
            if (record == null)
            {
                return -2;
            }
            record.ModifiedBy = model.CreatedBy;
            record.ModifiedDate = DateTime.Now;
            record.CaseTypeName = model.CaseTypeName;
            record.Code = model.Code;
            
            return await this.unitOfWork.CaseTypes.UpdateAsync(record);
        }
        public async Task<IEnumerable<CaseTypeModel>> FetchAllAsync(CaseTypeModel model)
        {
            var where = "where 1=1";
            if (model.CaseTypeId > 0)
            {
                where += $@" and  cs.""CaseTypeId"" = {model.CaseTypeId} ";
            }
            var query = $@"select count(cs.""CaseTypeId"") over() as ""TotalItems"", cs.""CaseTypeId"", cs.""CaseTypeName"",cs.""Code"", cs.""Active"", cs.""CreatedBy"", cs.""CreatedDate"",
		                        cs.""ModifiedBy"", cs.""ModifiedDate"",
		                        C.""FullName"" as ""CreatedByName"", CR.""RoleName"" as ""CreatedByRole"",M.""FullName"" as ""ModifiedByName"", MR.""RoleName"" as ""ModifiedByRole""
                             FROM ""CaseType"" cs 
                             join ""Account"" C on C.""AccountId"" = cs.""CreatedBy""
                             join ""Role"" CR on CR.""RoleId"" = C.""RoleId""
                             left join ""Account"" M on M.""AccountId"" = cs.""ModifiedBy""
                             left join ""Role"" MR on MR.""RoleId"" = M.""RoleId""
                                {where}
                             order by cs.""CreatedDate"" desc";


            return await this.unitOfWork.Current.QueryAsync<CaseTypeModel>(query);

        }

        public async Task<int> ActivateOrDeactivateTest(CaseTypeModel model)
        {
            var query = $@"UPDATE ""CaseType""
	                           SET ""ModifiedBy""={model.ModifiedBy}, ""ModifiedDate""=now(), ""Active""= {model.Active}
	                           WHERE ""CaseTypeId""= {model.CaseTypeId}";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }
    }
}
