﻿#nullable enable
namespace Hims.Infrastructure.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.UserModels.Exports;

    /// <inheritdoc />
    public class ExportServices : IExportService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IExportService" />
        public ExportServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task<IEnumerable<PaymentExportModel>> FetchPaymentsAsync(
            string? fromDate,
            string? toDate,
            int? providerId,
            int pageIndex,
            int pageSize)
        {
            fromDate = fromDate == null ? "null" : "'" + fromDate + "'";
             toDate = toDate == null ? "null" : "'" + toDate + "'";
           

            var query = $@"SELECT * FROM ""udf_AppointmentsTransByProvider""({providerId}, null,null,null,null,null,null,{fromDate}, {toDate},null,null)";
            return this.unitOfWork.Current.QueryAsync<PaymentExportModel>(query);
        }
    }
}