﻿

namespace Hims.Infrastructure.Services
{
    using Dapper;
    using Hims.Domain.Entities;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Domain.Services;
    using Hims.Shared.UserModels;
    using System;
    using System.Collections.Generic;
    using System.Text;
    using System.Threading.Tasks;
    public class WorkingHourServices : IWorkingHourService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;
        /// <inheritdoc cref="IWorkingHourService" />
        public WorkingHourServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<IEnumerable<WorkingHourModel>> FetchAllAsyn(WorkingHourModel model)
        {
            var where = "where 1=1";
            var query = $@"select WH.""WorkingHourId"", WH.""StartTime"", WH.""StartDate"", WH.""EndDate"", WH.""EndTime"", WH.""Active"",WH.""CreatedBy"", WH.""CreatedDate"",
		                        WH.""ModifiedBy"", WH.""ModifiedDate"",
								 ac.""FullName"" as ""CreatedByName"", CR.""RoleName"" as ""CreatedByRole"",
								 M.""FullName"" as ""ModifiedByName"", MR.""RoleName"" as ""ModifiedByRole""
                                from ""WorkingHour"" WH
                                JOIN ""Account"" ac on ac.""AccountId""=WH.""CreatedBy""
								join ""Role"" CR on CR.""RoleId"" = ac.""RoleId""
								 left join ""Account"" M on M.""AccountId"" = WH.""ModifiedBy""
                             left join ""Role"" MR on MR.""RoleId"" = M.""RoleId""
                                              { where}
                                 order by WH.""CreatedDate"" desc";               
            return await this.unitOfWork.Current.QueryAsync<WorkingHourModel>(query);
        }

        public async Task<int> InsertAsync(WorkingHourModel model)
        {

           
       
                var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""WorkingHour"" where  ""StartDate"" ilike'{model.StartDate}' and ""EndDate"" ilike '{model.EndDate}' and ""StartTime""  ilike '{model.StartTime}' and ""EndTime"" ilike '{model.EndTime}'");
                if (checkIf > 0)
                {
                    return -1;
                }

                var workingHour = new WorkingHour
                {
                    StartDate = model.StartDate,
                    StartTime = model.StartTime,
                    EndDate = model.EndDate,
                    EndTime = model.EndTime,
                    CreatedBy = model.CreatedBy,
                    Active = true,
                    CreatedDate = DateTime.Now,
                };
                return await this.unitOfWork.WorkingHour.InsertAsync(workingHour);
            
           
        }
        public async Task<int> ActivateOrDeactivateTest(WorkingHourModel model)
        {
            var query = $@"UPDATE ""WorkingHour""
	                           SET ""ModifiedBy""={model.CreatedBy}, ""ModifiedDate""=now(), ""Active""= {model.Active}
	                           WHERE ""WorkingHourId""= {model.WorkingHourId}";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }
        /// <inheritdoc/>
        public async Task<int> UpdateAsync(WorkingHourModel model)
        {
                var record = await this.unitOfWork.WorkingHour.FindAsync(m => m.WorkingHourId == model.WorkingHourId);
                if (record == null)
                {
                    return -2;
                }
                record.ModifiedBy = model.CreatedBy;
                record.ModifiedDate = DateTime.Now;
                record.StartDate = model.StartDate;
                record.StartTime = model.StartTime;
                record.EndDate = model.EndDate;
                record.EndTime = model.EndTime;

            return await this.unitOfWork.WorkingHour.UpdateAsync(record);
            
        }

    }
}
