﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.UserModels.DoctorScheduleVisits;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IDoctorScheduleVisitsService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        
        Task<IEnumerable<ViewModel>> FetchDoctorVisitsAsync(FilterModel model);
       
        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(InsertModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        /// 
        Task<int> UpdateAsync(InsertModel model);

        /// <summary>
        /// the Modify async
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        Task<int> ModifyStatusAsync(InsertModel model);
    }
}
