﻿namespace Hims.Shared.UserModels.BedManagement.Room
{
    /// <summary>
    /// The common response.
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the ward identifier.
        /// </summary>
        /// <value>
        /// The ward identifier.
        /// </value>
        public int RoomId { get; set; }

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the room rent.
        /// </summary>
        /// <value>
        /// The room rent.
        /// </value>
        public double? RoomRent { get; set; }

        /// <summary>
        /// Gets or sets the total beds.
        /// </summary>
        /// <value>
        /// The total beds.
        /// </value>
        public int? TotalBeds { get; set; }

        /// <summary>
        /// Gets or sets the total beds available.
        /// </summary>
        /// <value>
        /// The total beds available.
        /// </value>
        public int? TotalBedsAvailable { get; set; }

        /// <summary>
        /// Gets or sets the total beds cleaning.
        /// </summary>
        /// <value>
        /// The total beds cleaning.
        /// </value>
        public int? TotalBedsCleaning { get; set; }

        /// <summary>
        /// Gets or sets the total beds occupied.
        /// </summary>
        /// <value>
        /// The total beds occupied.
        /// </value>
        public int? TotalBedsOccupied { get; set; }
    }
}
