﻿namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The provider list item filter model.
    /// </summary>
    public class ProviderListItemFilterModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the practice id.
        /// </summary>
        public int? PracticeId { get; set; }

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the service id.
        /// </summary>
        public int? ServiceId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is telemedicine.
        /// </summary>
        public bool? IsTelemedicine { get; set; }

        /// <summary>
        /// Gets or sets the search param.
        /// </summary>
        public string? SearchParam { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the provider ids.
        /// </summary>
        public string? ProviderIds { get; set; }

        /// <summary>
        /// Gets or sets the location Id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the location Id.
        /// </summary>
        public string ConsultationName { get; set;
        }
    }
}
