﻿namespace Hims.Shared.UserModels.Labs
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The lab booking model.
    /// </summary>
    public class LabBookingModel
    {
        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int? NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        /// <value>
        /// The mobile.
        /// </value>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the name of the doctor.
        /// </summary>
        /// <value>
        /// The name of the doctor.
        /// </value>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the doctor identifier.
        /// </summary>
        /// <value>
        /// The doctor identifier.
        /// </value>
        public int? DoctorId { get; set; }

        /// <summary>
        /// Gets or sets the employee identifier.
        /// </summary>
        /// <value>
        /// The employee identifier.
        /// </value>
        public int? EmployeeId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the overall discount percentage.
        /// </summary>
        /// <value>
        /// The overall discount percentage.
        /// </value>
        public double? OverallDiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the overall total amount.
        /// </summary>
        /// <value>
        /// The overall total amount.
        /// </value>
        public double OverallTotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        /// <value>
        /// The overall discount.
        /// </value>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        /// <value>
        /// The overall net amount.
        /// </value>
        public double OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the pay type identifier.
        /// </summary>
        /// <value>
        /// The pay type identifier.
        /// </value>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        /// <value>
        /// The payment number.
        /// </value>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public string ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        /// <value>
        /// The active.
        /// </value>
        public bool? Active { get; set; }


        /// <summary>
        /// Gets or sets the labs.
        /// </summary>
        /// <value>
        /// The labs.
        /// </value>
        public List<NewLabBookingDetailModel> Labs { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail URL.
        /// </summary>
        /// <value>
        /// The patient thumbnail URL.
        /// </value>
        public string PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the name of the employee.
        /// </summary>
        /// <value>
        /// The name of the employee.
        /// </value>
        public string EmployeeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the pay type.
        /// </summary>
        /// <value>
        /// The name of the pay type.
        /// </value>
        public string PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public string FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the is show sample collected.
        /// </summary>
        /// <value>
        /// The is show sample collected.
        /// </value>
        public bool? IsShowSampleCollected { get; set; }
        /// <summary>
        /// gets or sets the Index Number of Labs which is used to get the which lab has to be cancelled for single individual
        /// </summary>
        public int? index { get; set; }

        /// <summary>
        /// gets or sets the NewLabCancelBookingHeaderId.
        /// </summary>
        public int? NewLabCancelBookingHeaderId { get; set; }

        /// <summary>
        /// gets or sets the TotalReturnAmount.
        /// </summary>
        public double? TotalReturnAmount { get; set; }

        /// <summary>
        /// gets or sets the Refund Amount.
        /// </summary>
        public double? RefundAmount { get; set; }

        /// <summary>
        /// Gets or sets the appointment identifier.
        /// </summary>
        /// <value>
        /// The appointment identifier.
        /// </value>
        public int? AppointmentId { get; set; }


        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime? DateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the name of the doctor's department.
        /// </summary>
        /// <value>
        /// The name of the doctor department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public int? LabDepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string LabDepartmentName { get; set; }



        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public string? EncryptedId { get; set; }
        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double? TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double? NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the grand total.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double? GrandTotal { get; set; }

        /// <summary>
        /// Gets or sets the Payment status.
        /// </summary>
        public bool PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string SalucroTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the payment initiation log identifier.
        /// </summary>
        /// <value>
        /// The payment initiation log identifier.
        /// </value>
        public int? PaymentInitiationLogId { get; set; }

        /// <summary>
        /// Gets or sets the is salucro bill.
        /// </summary>
        public bool IsSalucroBill { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int? NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the name of the file.
        /// </summary>
        /// <value>
        /// The name of the file.
        /// </value>
        public string FileName { get; set; }

        /// <summary>
        /// Gets or sets the labs.
        /// </summary>
        /// <value>
        /// The labs.
        /// </value>
        public string LabList { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? StatusDate { get; set; }
        /// <summary>
        /// Gets or sets the name of the uploaded by.
        /// </summary>
        /// <value>
        /// The name of the uploaded by.
        /// </value>
        public string Fetchfor { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <value>
        /// The lab booking status identifier.
        /// </value>
        public int? LabBookingStatusId { get; set; }

        /// <summary>
        /// Gets or sets the type of the booking.
        /// </summary>
        /// <value>
        /// The type of the booking.
        /// </value>
        public string BookingType { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string TypeOfPayment { get; set; }

        public int? PackageId { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        /// <value>
        /// The overall net amount.
        /// </value>
        public double? PaidAmount { get; set; }
        public bool? ReceiptSaving { get; set; }
        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int? LabMainDetailId { get; set; }
    }

    /// <summary>
    /// The new lab booking detail.
    /// </summary>
    public class NewLabBookingDetailModel
    {
        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking status identifier.
        /// </summary>
        /// <value>
        /// The lab booking status identifier.
        /// </value>
        public int LabBookingStatusId { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        /// <value>
        /// The discount percentage.
        /// </value>
        public double? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the test code.
        /// </summary>
        /// <value>
        /// The test code.
        /// </value>
        public string TestCode { get; set; }



        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge category.
        /// </summary>
        /// <value>
        /// The name of the charge category.
        /// </value>
        public string ChargeCategoryName { get; set; }

        /// <summary>
        /// gets or sets the Return Amount
        /// </summary>
        public double? ReturnAmount { get; set; }

        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string RowColor { get; set; }

        /// <summary>
        /// Gets or sets the name of the collected by.
        /// </summary>
        /// <value>
        /// The name of the collected by.
        /// </value>
        public string CollectedByName { get; set; }

        /// <summary>
        /// Gets or sets the collection date.
        /// </summary>
        /// <value>
        /// The collection date.
        /// </value>
        public DateTime? CollectionDate { get; set; }

        /// <summary>
        /// Gets or sets the lab service identifier.
        /// </summary>
        /// <value>
        /// The lab service identifier.
        /// </value>
        public int? LabServicesId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is internal lab.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is internal lab; otherwise, <c>false</c>.
        /// </value>
        public bool IsInternalLab { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is external lab.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is external lab; otherwise, <c>false</c>.
        /// </value>
        public bool IsExternalLab { get; set; }

        /// <summary>
        /// Gets or sets the report URL.
        /// </summary>
        /// <value>
        /// The report URL.
        /// </value>
        public string ReportUrl { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the uploaded by.
        /// </summary>
        /// <value>
        /// The name of the uploaded by.
        /// </value>
        public string UploadedByName { get; set; }

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        /// <value>
        /// The uploaded date.
        /// </value>
        public DateTime? UploadedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="NewLabBookingDetailModel"/> is emergency.
        /// </summary>
        /// <value>
        ///   <c>true</c> if emergency; otherwise, <c>false</c>.
        /// </value>
        public bool? Emergency { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the test precaution.
        /// </summary>
        /// <value>
        /// The test precaution.
        /// </value>
        public string TestPrecaution { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [home sample].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [home sample]; otherwise, <c>false</c>.
        /// </value>
        public bool? HomeSample { get; set; }
    }
}
