﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Labs
{
    /// <summary>
    /// The LabParameterResultsModel.
    /// </summary>
    public class LabParameterResultsModel
    {
        /// <summary>
        /// Gets or sets the lab parameter observedvalue identifier.
        /// </summary>
        /// <value>
        /// The lab parameter observedvalue identifier.
        /// </value>
        public int LabParameterObservedValueId { get; set; }

        /// <summary>
        /// Gets or sets the observedvalue.
        /// </summary>
        /// <value>
        /// The observedvalue.
        /// </value>
        public string ObservedValue { get; set; }

        /// <summary>
        /// Gets or sets the count.
        /// </summary>
        /// <value>
        /// The count.
        /// </value>
        public long Count { get; set; }

        /// <summary>
        /// Gets or sets the parameterName.
        /// </summary>
        /// <value>
        /// The parameterName.
        /// </value>
        public string ParameterName { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabParameterResultsModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is changed.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is changed; otherwise, <c>false</c>.
        /// </value>
        public bool IsChanged { get; set; }
    }
}
