﻿namespace Hims.Shared.UserModels
{
    using System.Collections.Generic;
    using EntityModels;
    using Hims.Shared.Library;
    using Hims.Shared.UserModels.Labs;
    using Hims.Shared.UserModels.Scan.ScanAppointment;

    /// <summary>
    /// The patient profile model.
    /// </summary>
    public class PatientTimeLineModel
    {
        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        public PatientModel Patient { get; set; }

        /// <summary>
        /// Gets or sets the appointments.
        /// </summary>
        public IEnumerable<AppointmentModel> Appointments { get; set; }

        /// <summary>
        /// Gets or sets the insurances.
        /// </summary>
        public IEnumerable<AdmissionModel> Admissions { get; set; }

        /// <summary>
        /// Gets or sets the relative details.
        /// </summary>
        public IEnumerable<PharmacyBillReportModel> Pharamcy { get; set; }

        public IEnumerable<LabBookingModel> Labs { get; set; }
        public IEnumerable<FetchBookScanAppointment> Scan { get; set; }
        public IEnumerable<OTRegisterFilterModel> OTData { get; set; }
        //public IEnumerable<FetchBookScanAppointment> Scan { get; set; }
    }
}