﻿using System;

namespace Hims.Shared.UserModels.Vendors
{
    /// <summary>
    /// The pharmacy product request model.
    /// </summary>
    public class PharmacyProductRequestModel
    {
        /// <summary>
        /// Gets or sets the stock identifier.
        /// </summary>
        /// <value>
        /// The stock identifier.
        /// </value>
        public string StockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the raised by.
        /// </summary>
        /// <value>
        /// The name of the raised by.
        /// </value>
        public string RaisedByName { get; set; }

        /// <summary>
        /// Gets or sets the suppliers.
        /// </summary>
        /// <value>
        /// The suppliers.
        /// </value>
        public string Suppliers { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock ids.
        /// </summary>
        /// <value>
        /// The pharmacy stock ids.
        /// </value>
        public string PharmacyStockIds { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product request ids.
        /// </summary>
        /// <value>
        /// The pharmacy product request ids.
        /// </value>
        public string PharmacyProductRequestIds { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product request identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product request identifier.
        /// </value>
        public int PharmacyProductRequestId { get; set; }

        /// <summary>
        /// Gets or sets the raised date.
        /// </summary>
        /// <value>
        /// The raised date.
        /// </value>
        public DateTime RaisedDate { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the tax identifier.
        /// </summary>
        /// <value>
        /// The tax identifier.
        /// </value>
        public int? TaxId { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the price history.
        /// </summary>
        /// <value>
        /// The price history.
        /// </value>
        public VendorPurchaseProductList PriceHistory { get; set; }

        /// <summary>
        /// Gets or sets the prefered vendor.
        /// </summary>
        /// <value>
        /// The prefered vendor.
        /// </value>
        public VendorPurchaseProductList PreferedVendor { get; set; }

        /// <summary>
        /// Gets or sets the price authority.
        /// </summary>
        /// <value>
        /// The price authority.
        /// </value>
        public string PriceAuthority { get; set; }

        /// <summary>
        /// Gets or sets the type of the fetch.
        /// </summary>
        /// <value>
        /// The type of the fetch.
        /// </value>
        public string FetchType { get; set; }

        /// <summary>
        /// Gets or sets the reorder quantity.
        /// </summary>
        /// <value>
        /// The reorder quantity.
        /// </value>
        public int ReorderQuantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        /// <value>
        /// The free.
        /// </value>
        public int? Free { get; set; }

        /// <summary>
        /// Gets or sets the source.
        /// </summary>
        /// <value>
        /// The source.
        /// </value>
        public string Source { get; set; }

        /// <summary>
        /// Gets or sets the approval given by.
        /// </summary>
        /// <value>
        /// The approval given by.
        /// </value>
        public int? ApprovalGivenBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the approval given by.
        /// </summary>
        /// <value>
        /// The name of the approval given by.
        /// </value>
        public string ApprovalGivenByName { get; set; }

        /// <summary>
        /// Gets or sets the approval given date.
        /// </summary>
        /// <value>
        /// The approval given date.
        /// </value>
        public DateTime? ApprovalGivenDate { get; set; }

        /// <summary>
        /// Gets or sets the complete vendor list.
        /// </summary>
        /// <value>
        /// The complete vendor list.
        /// </value>
        public VendorPurchaseHistory CompleteVendorList { get; set; }

        /// <summary>
        /// Gets or sets the requested quantity.
        /// </summary>
        /// <value>
        /// The requested quantity.
        /// </value>
        public int? RequestedQuantity { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [inventory item].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [inventory item]; otherwise, <c>false</c>.
        /// </value>
        public bool InventoryItem { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }
    }
}
