﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using System;
using System.Text;

namespace Hims.Admin.Controllers
{
    public class PaymentController : Controller
    {
        private readonly IConfiguration configuration;

        public PaymentController(IConfiguration configuration)
        {
            this.configuration = configuration;
        }

        public IActionResult Result(IFormCollection collection)
        {
            dynamic item = JsonConvert.DeserializeObject(collection["responseToken"]);
            int salucroStatusCode = item["status_code"];
            string mode = item["custom4"];
            //this.ViewBag.paymentMapHelperId = "Bill-"+item["custom"];
            string custom = item["custom"];
            string encodedCredential = "";
            int admissionId = item["custom5"] ?? 0;
            string module = item["custom6"];
            string typeOfpayment = item["custom3"];
            if (!string.IsNullOrEmpty(custom))
            {
                encodedCredential = Convert.ToBase64String(Encoding.UTF8.GetBytes(custom));
                this.ViewBag.paymentMapHelperId = "Bill-" + encodedCredential;
            }

            if (mode == "Payment")
            {
                bool isMultiPayments = item["custom2"];
                int moduleId = item["custom1"];
                switch (moduleId)
                {
                    case 1:
                        //Patient Registration success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Thank you for making payment. Patient Registered  successfully.";
                            this.ViewBag.routingUrlWithBillId = "#/app/patients";
                            //this.ViewBag.routingUrlWithBillId = "#/app/patients/edit/Bill-" + encodedCredential.ToString();
                            this.ViewBag.paymentType = "Payment Success";
                            return this.View("PaymentSuccess");
                        }

                        //pending transaction from salucro
                        else if (salucroStatusCode == 1201)
                        {
                            this.ViewBag.message = "Thank you. Patient Registered successfully. Make the payment to check in and consult.";
                            this.ViewBag.routingUrlWithBillId = "#/app/patients";
                            this.ViewBag.paymentType = "Payment Inprogress";
                            return this.View("PaymentPending");
                        }

                        //failed transaction
                        else
                        {
                            this.ViewBag.message = "Sorry. Payment got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/patients";
                            this.ViewBag.paymentType = "Payment Failure";
                            return this.View("PaymentFailure");
                        }
                    case 2:
                        //appointment success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Thank you for making payment. Appointment has been booked successfully.";
                            this.ViewBag.routingUrlWithBillId = isMultiPayments ? "#/app/init-payment" : "#/app/out-patients";
                            //this.ViewBag.routingUrlWithBillId = "#/app/out-patients";
                            this.ViewBag.paymentType = "Payment Success";
                            return this.View("PaymentSuccess");
                        }

                        //pending transaction from salucro
                        else if (salucroStatusCode == 1201)
                        {
                            this.ViewBag.message = "Thank you. Appointment has been booked successfully. Make the payment to check in and consult.";
                            this.ViewBag.routingUrlWithBillId = "#/app/out-patients";
                            this.ViewBag.paymentType = "Payment Inprogress";
                            return this.View("PaymentPending");
                        }

                        //failed transaction
                        else
                        {
                            this.ViewBag.message = "Sorry. Payment got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/out-patients";
                            this.ViewBag.paymentType = "Payment Failure";
                            return this.View("PaymentFailure");
                        }
                    case 3:
                        //pharmacy success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Thank you for making payment. Your Pharmacy sale bill has been added successfully.";
                            var redirectToIfNotMultpile = (typeOfpayment == "FullPayment" || typeOfpayment == "MultiPaymodes") ? "#/app/pharmacy/sales-bill/Bill-" + encodedCredential.ToString(): "#/app/pharmacy/sales-bill";
                            this.ViewBag.routingUrlWithBillId = isMultiPayments ? "#/app/init-payment" : redirectToIfNotMultpile;
                            this.ViewBag.paymentType = "Payment Success";
                            return this.View("PaymentSuccess");
                        }

                        //pending transaction from salucro
                        else if (salucroStatusCode == 1201)
                        {
                            this.ViewBag.message = "Thank you. Your Pharmacy sale bill will only be added after the payment got the success.";
                            this.ViewBag.routingUrlWithBillId = "#/app/pharmacy/sales-bill";
                            this.ViewBag.paymentType = "Payment Inprogress";
                            return this.View("PaymentPending");
                        }

                        //failed transaction
                        else
                        {
                            this.ViewBag.message = "Sorry. Payment got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/pharmacy/sales-bill";
                            this.ViewBag.paymentType = "Payment Failure";
                            return this.View("PaymentFailure");
                        }
                    case 4:
                        //labs success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Thank you for making payment. Your Lab bill has been added successfully.";
                            var redirectToIfNotMultpile = (typeOfpayment == "FullPayment" || typeOfpayment == "MultiPaymodes") ? "#/app/labs/lab-billing/Bill-" + encodedCredential.ToString() : "#/app/labs/lab-billing";
                            this.ViewBag.routingUrlWithBillId = isMultiPayments ? "#/app/init-payment" : redirectToIfNotMultpile;
                            this.ViewBag.paymentType = "Payment Success";
                            return this.View("PaymentSuccess");
                            //return this.View("LabBillSuccess");
                        }

                        //pending transaction from salucro
                        else if (salucroStatusCode == 1201)
                        {
                            this.ViewBag.message = "Thank you. Your Lab  bill will only be added after the payment got the success.";
                            this.ViewBag.routingUrlWithBillId = "#/app/labs/lab-billing";
                            this.ViewBag.paymentType = "Payment Inprogress";
                            return this.View("PaymentPending");
                        }

                        //failed transaction
                        else
                        {
                            this.ViewBag.message = "Sorry. Payment got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/labs/lab-billing";
                            this.ViewBag.paymentType = "Payment Failure";
                            return this.View("PaymentFailure");
                        }
                    case 5:
                        //Scan Appointment success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            if (module == "ScanNotification")
                            {
                                this.ViewBag.routingUrlWithBillId = "#/app/web-notification";
                            }
                            else
                            {
                                this.ViewBag.routingUrlWithBillId = isMultiPayments ? "#/app/init-payment" : "#/app/scan-appointment/booking-scan-appointment";
                                //this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/booking-scan-appointment";
                            }
                            this.ViewBag.message = "Thank you for making payment. Your Scan Appointment has been booked successfully.";
                            //this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/booking-scan-appointment";
                            this.ViewBag.paymentType = "Payment Success";
                            return this.View("PaymentSuccess");
                        }

                        //pending transaction from salucro
                        else if (salucroStatusCode == 1201)
                        {
                            if (module == "ScanNotification")
                            {
                                this.ViewBag.routingUrlWithBillId = "#/app/web-notification";
                            }
                            else
                            {
                                this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/booking-scan-appointment";
                            }
                            this.ViewBag.message = "Thank you. Your Scan Appointment will only be booked after the payment got the success.";
                            //this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/booking-scan-appointment";
                            this.ViewBag.paymentType = "Payment Inprogress";
                            return this.View("PaymentPending");
                        }

                        //failed transaction
                        else
                        {
                            if (module == "ScanNotification")
                            {
                                this.ViewBag.routingUrlWithBillId = "#/app/web-notification";
                            }
                            else
                            {
                                this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/booking-scan-appointment";
                            }
                            this.ViewBag.message = "Sorry. Payment got failed. Please try again..";
                            //this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/booking-scan-appointment";
                            this.ViewBag.paymentType = "Payment Failure";
                            return this.View("PaymentFailure");
                        }

                    case 6:
                        //Adding Receipt success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Thank you for making payment. Your Receipt has been added successfully.";
                            this.ViewBag.routingUrlWithBillId = "#/app/services/" + admissionId + "/a/receipts";
                            this.ViewBag.paymentType = "Payment Success";
                            return this.View("PaymentSuccess");
                        }

                        //pending transaction from salucro
                        else if (salucroStatusCode == 1201)
                        {
                            this.ViewBag.message = "Thank you. Your Receipt will only be added after the payment got the success.";
                            this.ViewBag.routingUrlWithBillId = "#/app/services/" + admissionId + "/a/receipts";
                            this.ViewBag.paymentType = "Payment Inprogress";
                            return this.View("PaymentPending");
                        }

                        //failed transaction
                        else
                        {
                            this.ViewBag.message = "Sorry. Payment got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/services/" + admissionId + "/a/receipts";
                            this.ViewBag.paymentType = "Payment Failure";
                            return this.View("PaymentFailure");
                        }

                    case 7:
                        //View machine success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Thank you for making payment. Your Scan Appointment has been booked successfully.";
                            this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/machine-wise-booking";
                            this.ViewBag.paymentType = "Payment Success";
                            return this.View("PaymentSuccess");
                        }

                        //pending transaction from salucro
                        else if (salucroStatusCode == 1201)
                        {
                            this.ViewBag.message = "Thank you. Your Scan Appointment will only be booked after the payment got the success.";
                            this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/machine-wise-booking";
                            this.ViewBag.paymentType = "Payment Inprogress";
                            return this.View("PaymentPending");
                        }

                        //failed transaction
                        else
                        {
                            this.ViewBag.message = "Sorry. Payment got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/machine-wise-booking";
                            this.ViewBag.paymentType = "Payment Failure";
                            return this.View("PaymentFailure");
                        }
                }
            }
            else if (mode == "Refund")
            {
                int moduleId = item["custom3"];
                switch (moduleId)
                {
                    case 1:
                        break;
                    case 2:
                        break;
                    case 3:
                        //pharmacy return success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Bill Returned Successfully and Refund Initiated.";
                            this.ViewBag.routingUrlWithBillId = "#/app/pharmacy/sales-return/Bill-" + encodedCredential.ToString();
                            this.ViewBag.paymentType = "Refund Success";
                            return this.View("PaymentSuccess");
                        }

                        //failed transaction
                        else
                        {
                            this.ViewBag.message = "Sorry. Refund got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/pharmacy/sales-return";
                            this.ViewBag.paymentType = "Refund Failure";
                            return this.View("PaymentFailure");
                        }
                    case 4:
                        //Labs  bill success transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Lab Bill Returned Successfully and Refund Initiated.";
                            this.ViewBag.routingUrlWithBillId = "#/app/labs/labs-cancellation/Bill-" + encodedCredential.ToString();
                            this.ViewBag.paymentType = "Refund Success";
                            return this.View("PaymentSuccess");
                        }

                        //failed transaction
                        else
                        {
                            this.ViewBag.message = "Sorry. Refund got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/labs/labs-cancellation";
                            this.ViewBag.paymentType = "Refund Failure";
                            return this.View("PaymentFailure");
                        }
                    case 5:
                        // Scan Appointment return transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Your Scan Appointment has been Cancelled successfully! and Refund Initiated.";
                            this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/booking-scan-appointment";
                            this.ViewBag.paymentType = "Refund Success";
                            return this.View("PaymentSuccess");
                        }
                        //failed transaction 
                        else
                        {
                            this.ViewBag.message = "Sorry. Refund got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/booking-scan-appointment";
                            this.ViewBag.paymentType = "Refund Failure";
                            return this.View("PaymentFailure");
                        }
                    case 6:
                        // Receipt refund transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Your Refund Receipt Added successfully! and Refund Initiated.";
                            this.ViewBag.routingUrlWithBillId = "#/app/services/" + admissionId + "/a/receipts";
                            this.ViewBag.paymentType = "Refund Success";
                            return this.View("PaymentSuccess");
                        }
                        //failed transaction 
                        else
                        {
                            this.ViewBag.message = "Sorry. Refund got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/services/" + admissionId + "/a/receipts";
                            this.ViewBag.paymentType = "Refund Failure";
                            return this.View("PaymentFailure");
                        }
                    case 7:
                        // View machine return transaction from salucro
                        if (salucroStatusCode == 1200)
                        {
                            this.ViewBag.message = "Your Scan Appointment has been Cancelled successfully! and Refund Initiated.";
                            this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/machine-wise-booking";
                            this.ViewBag.paymentType = "Refund Success";
                            return this.View("PaymentSuccess");
                        }
                        //failed transaction 
                        else
                        {
                            this.ViewBag.message = "Sorry. Refund got failed. Please try again..";
                            this.ViewBag.routingUrlWithBillId = "#/app/scan-appointment/machine-wise-booking";
                            this.ViewBag.paymentType = "Refund Failure";
                            return this.View("PaymentFailure");
                        }
                }
            }
            else if (mode == "refund")
            {
                //appointment cancel success transaction from salucro
                if (salucroStatusCode == 1200)
                {
                    this.ViewBag.message = " Appointment Cancelled Successfully and Refund Initiated.";
                    this.ViewBag.routingUrlWithBillId = "#/app/out-patients/Bill-" + encodedCredential.ToString();
                    this.ViewBag.paymentType = "Refund Success";
                    return this.View("PaymentSuccess");
                }

                //failed transaction
                else
                {
                    this.ViewBag.message = "Sorry. Refund got failed. Please try again..";
                    this.ViewBag.routingUrlWithBillId = "#/app/out-patients";
                    this.ViewBag.paymentType = "Refund Failure";
                    return this.View("PaymentFailure");
                }
            }
            else if (mode == null)
            {
                switch (salucroStatusCode)
                {

                    case 1200:
                        this.ViewBag.content = "Request Processed Successfully";
                        return this.View("CommonFailure");
                    case 1400:
                        this.ViewBag.content = "Bad Request";
                        return this.View("CommonFailure");
                    case 1401:
                        this.ViewBag.content = "Unauthorized Request";
                        return this.View("CommonFailure");
                    case 1404:
                        this.ViewBag.content = "Invalid  Request";
                        return this.View("CommonFailure");
                    case 1406:
                        this.ViewBag.content = "Duplicate  Request";
                        return this.View("CommonFailure");
                    case 1422:
                        this.ViewBag.content = "Invalid/Missing Parameters";
                        return this.View("CommonFailure");
                    case 1417:
                        this.ViewBag.content = "Insufficient Balance or Exceeded Amount";
                        return this.View("CommonFailure");
                    case 1201:
                        this.ViewBag.content = "Transaction Created";
                        return this.View("CommonFailure");
                    case 1424:
                        this.ViewBag.content = "Request can't be processed";
                        return this.View("CommonFailure");
                    case 1499:
                        this.ViewBag.content = "Payment Cancelled";
                        return this.View("CommonFailure");
                }

            }
            return this.View("CommonFailure");
        }



    }
}
