﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class AppointmentDashboardModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient account id.
        /// </summary>
        public int PatientAccountId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient marital status.
        /// </summary>
        public char? PatientMaritalStatus { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient email.
        /// </summary>
        public string? PatientEmail { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string? EncounterType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is prescription.
        /// </summary>
        public bool IsPrescription { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is full transcript.
        /// </summary>
        public bool IsFullTranscript { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier.
        /// </summary>
        /// <value>
        /// The provider identifier.
        /// </value>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider location identifier.
        /// </summary>
        /// <value>
        /// The provider location identifier.
        /// </value>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the provider.
        /// </summary>
        /// <value>
        /// The name of the provider.
        /// </value>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the queue status.
        /// </summary>
        /// <value>
        /// The queue status.
        /// </value>
        public string? QueueStatus { get; set; }
        /// <summary>
        /// Gets or sets the umrno.
        /// </summary>
        /// <value>
        /// The queue umrno.
        /// </value>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the consultationTypeId.
        /// </summary>
        /// <value>
        /// The consultationTypeId.
        /// </value>
        public int? ConsultationTypeId { get; set; }
        /// <summary>
        /// Gets or sets the specializationId.
        /// </summary>
        /// <value>
        /// The queue specializationId.
        /// </value>
        public int? SpecializationId { get; set; }
        /// <summary>
        /// Gets or sets the providerAvailabilityId.
        /// </summary>
        /// <value>
        /// The queue providerAvailabilityId.
        /// </value>
        public int? ProviderAvailabilityId { get; set; }
        /// <summary>
        /// Gets or sets the provider mail id.
        /// </summary>
        /// <value>
        /// The queue provider mail id.
        /// </value>
        public string? ProviderEmail { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        /// <value>
        /// The room name.
        /// </value>
        public string? RoomName { get; set; }
    }
}
