﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary> The general advice.</summary>
    public class GeneralAdviceModel
    {
        /// <summary>Gets or sets the general advice id.</summary>
        public int GeneralAdviceId { get; set; }

        /// <summary>Gets or sets the full name.</summary>
        public string? FullName { get; set; }

        /// <summary>Gets or sets the description.</summary>
        public string? Description { get; set; }

        /// <summary>Gets or sets the created by.</summary>
        public int CreatedBy { get; set; }

        /// <summary>Gets or sets the created date.</summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>Gets or sets the modified by.</summary>
        public int? ModifiedBy { get; set; }

        /// <summary>Gets or sets the modified date.</summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>Gets or sets the is general advice assigned.</summary>
        public bool? IsAssignedGeneralAdvice { get; set; }

        /// <summary>Gets or sets the total items.</summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or Sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string EncryptedAppointmentId { get; set; }
    }
}
