﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The provider leave model.
    /// </summary>
    public class ProviderLeaveModel
    {
        /// <summary>
        /// Gets or sets the provider leave id.
        /// </summary>
        public long ProviderLeaveId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the leave date.
        /// </summary>
        public DateTime LeaveDate { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string? Reason { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
