﻿namespace Hims.Shared.UserModels.Laboratory
{
    using System;

    /// <summary>
    /// The lab report main model.
    /// </summary>
    public class LabReportMainModel
    {
        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        public int LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking header id.
        /// </summary>
        public int LabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public double Amount { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the value indicating is report generated.
        /// </summary>
        public bool? IsReportGenerated { get; set; }

        /// <summary>
        /// Gets or sets the report date.
        /// </summary>
        public DateTime? ReportDate { get; set; }

        /// <summary>
        /// Gets or sets the lab code.
        /// </summary> 
        public string LabCode { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string Signature { get; set; }

        /// <summary>
        /// Gets or sets
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public string PatientType { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the doctor name.
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the paid via.
        /// </summary>
        public string PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is sample collected.
        /// </summary>
        public bool? IsSampleCollected { get; set; }

        /// <summary>
        /// Gets or sets the sample date.
        /// </summary>
        public DateTime? SampleDate{get;set;}
    }
}
