﻿namespace Hims.Shared.UserModels.MasterBill
{
    using System;
    /// <summary>
    /// The receipt model
    /// </summary>
    public class InsertModel

    {
        /// <summary>
        /// Gets or sets the gatePass identifier.
        /// </summary>
        /// <value>
        /// The gatePass identifier.
        /// </value>
        public int? MasterBillId { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the  identifier.
        /// </summary>
        /// <value>
        /// The  identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the modules master identifier.
        /// </summary>
        /// <value>
        /// The modules master identifier.
        /// </value>
        public int? ReceiptAreaTypeId { get; set; }

        /// <summary>
        /// Gets or sets the cost
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
      public double Total { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        /// <value>
        /// The bill date.
        /// </value>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the bill status identifier.
        /// </summary>
        /// <value>
        /// The bill status identifier.
        /// </value>
        public int? BillStatusTypeId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by0.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime ModifiedDate { get; set; }
     
        /// <summary>
        /// gets or sets the roleId.
        /// </summary>
        public short RoleId { get; set; }

        /// <summary>
        /// gets or sets the fullName.
        /// </summary>
        public string FullName { get; set; }


        /// <summary>
        /// gets or sets the fullName.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the module name.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string ModuleName { get; set; }

        /// <summary>
        /// Gets or sets the module name.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the net total
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double NetTotal { get; set; }

        /// <summary>
        /// gets or sets the fullName.
        /// </summary>
        public string PaymentInitiationLogId { get; set; }

        /// <summary>
        /// gets or sets the fullName.
        /// </summary>
        public string PaymentIntiateUrl { get; set; }

        /// <summary>
        /// Gets or sets the net total
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double PaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the net total
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double PendingAmount { get; set; }

        /// <summary>
        /// Gets or sets the gatePass identifier.
        /// </summary>
        /// <value>
        /// The gatePass identifier.
        /// </value>
        public int? ModuleId { get; set; }
       // -------------------------------------------FETCH filter----------------------

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string FromDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string ToDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the location
        /// </summary>
        public int? LocationId { get; set; }

        // ------------------------------------------additional to get extra data ----------------------

        /// <summary>
        /// Gets or sets the bill status .
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string BillStatus { get; set; }

        /// <summary>
        /// Gets or sets the net total
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double Discount { get; set; }

        /// <summary>
        /// gets or sets the fullName.
        /// </summary>
        public string Receipts { get; set; }

        /// <summary>
        /// gets or sets the fullName.
        /// </summary>
        public string Receipts_Cost { get; set; }

        /// <summary>
        /// Gets or sets the net total
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public double ReceiptSum { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the appointment number.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        /// <value>
        /// The bill number.
        /// </value>
        public DateTime AppointmentDate { get; set; }

        public string PaymentRoute { get; set; }

        public double Tax { get; set; }

        public double RemovedAmount { get; set; }
    }
}
