﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The pharmacy sale bill.
    /// </summary>
    public class PharmacyPurchaseReportBill
    {
        /// <summary>
        /// Gets or sets the pharmacy purchase detail id.
        /// </summary>
        public int? PharmacyPurchaseDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy purchase header id.
        /// </summary>
        public int? PharmacyPurchaseHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the serial num.
        /// </summary>
        public int? SerialNum { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int? TaxId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int? PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int? Quantity { get; set; }

        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        public int? ReturnQuantity { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the totalAmount.
        /// </summary>
        public double? TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double? Total { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double? PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double? Mrp { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double? TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double? NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double? OverallTotal { get; set; }

        /// <summary>
        /// Gets or sets the overall taxes.
        /// </summary>
        public double? OverallTaxes { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double? OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the sale date.
        /// </summary>
        public DateTime? SaleDate { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the supplier name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the bill date.
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy bill type
        /// </summary>
        public bool? pharmacyBillType { get; set; }

        /// <summary>
        /// Gets or sets the paid via.
        /// </summary>
        public string PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the tax.
        /// </summary>
        public string Tax { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the due date.
        /// </summary>
        public string DueDate { get; set; }
        /// <summary>
        /// Gets or sets the available quantity.
        /// </summary>
        public int AvailableQuantity { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate/unit.
        /// </summary>
        public double? PurchaseRateUnit { get; set; }

        /// <summary>
        /// Gets or sets the mrp/unit.
        /// </summary>
        public double? MrpUnit { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine Fallow Up charges.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the Modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets remaining days.
        /// </summary>
        public int? DueDays { get; set; }

        /// <summary>
        /// Gets or sets  IsCreditClear .
        /// </summary>
        public bool? IsCreditClear { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int? SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the Credit Paid On Day date.
        /// </summary>
        public DateTime? PaidOnDate { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public double? Free { get; set; }

        /// <summary>
        /// Gets or sets the WareHouseName.
        /// </summary>
        public string? WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the return  date.
        /// </summary>
        public DateTime? ReturnDate { get; set; }

        /// <summary>
        /// Gets or sets the Return net amount.
        /// </summary>
        public double? ReturnNetamount { get; set; }

        /// <summary>
        /// Gets or sets the wareHouse id.
        /// </summary>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the payType id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string PaymentNumber { get; set; }
        /// <summary>
        /// Gets or sets the account number.
        /// </summary>
        public int? AccountId{ get; set; }
        /// <summary>
        /// Gets or sets texes.
        /// </summary>
        public double? Taxes { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

    }
}
