﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Vendors
{
    /// <summary>
    /// The supplier new product model.
    /// </summary>
    public class SupplierNewProductModel
    {
        /// <summary>
        /// Gets or sets the supplier product header identifier.
        /// </summary>
        /// <value>
        /// The supplier product header identifier.
        /// </value>
        public int SupplierProductHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the supplier identifier.
        /// </summary>
        /// <value>
        /// The supplier identifier.
        /// </value>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public int? LoginRoleId { get; set; }

        /// /// <summary>
        /// Gets or sets the login account identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public int? LoginAccountId { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the products.
        /// </summary>
        /// <value>
        /// The products.
        /// </value>
        public List<SupplierProductDetailModel> Products { get; set; }

        /// <summary>
        /// Gets or sets the stringified products.
        /// </summary>
        /// <value>
        /// The stringified products.
        /// </value>
        public string StringifiedProducts { get;set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is started.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is started; otherwise, <c>false</c>.
        /// </value>
        public bool IsStarted { get; set; }

        /// <summary>
        /// Gets or sets the days to expire.
        /// </summary>
        /// <value>
        /// The days to expire.
        /// </value>
        public int DaysToExpire { get; set; }

        /// <summary>
        /// Gets or sets the rate card URL.
        /// </summary>
        /// <value>
        /// The rate card URL.
        /// </value>
        public string RateCardUrl { get; set; }
    }

    /// <summary>
    /// The supplier product detail model.
    /// </summary>
    public class SupplierProductDetailModel
    {
        /// <summary>
        /// Gets or sets the supplier product detail identifier.
        /// </summary>
        /// <value>
        /// The supplier product detail identifier.
        /// </value>
        public int SupplierProductDetailId { get; set; }

        /// <summary>
        /// Gets or sets the supplier product header identifier.
        /// </summary>
        /// <value>
        /// The supplier product header identifier.
        /// </value>
        public int SupplierProductHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [inventory item].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [inventory item]; otherwise, <c>false</c>.
        /// </value>
        public bool InventoryItem { get; set; }

        /// <summary>
        /// Gets or sets the formulations.
        /// </summary>
        /// <value>
        /// The formulations.
        /// </value>
        public List<SupplierProductFormulationModel> Formulations { get; set; }

        /// <summary>
        /// Gets or sets the name of the purchase unit.
        /// </summary>
        /// <value>
        /// The name of the purchase unit.
        /// </value>
        public string PurchaseUnitName { get; set; }
    }

    /// <summary>
    /// The supplier product formulation model.
    /// </summary>
    public class SupplierProductFormulationModel
    {
        /// <summary>
        /// Gets or sets the supplier product formulation identifier.
        /// </summary>
        /// <value>
        /// The supplier product formulation identifier.
        /// </value>
        public int SupplierProductFormulationId { get; set; }

        /// <summary>
        /// Gets or sets the supplier product detail identifier.
        /// </summary>
        /// <value>
        /// The supplier product header identifier.
        /// </value>
        public int SupplierProductDetailId { get; set; }

        /// <summary>
        /// Gets or sets the operator.
        /// </summary>
        /// <value>
        /// The operator.
        /// </value>
        public string Operator { get; set; }

        /// <summary>
        /// Gets or sets the condition.
        /// </summary>
        /// <value>
        /// The condition.
        /// </value>
        public int Condition { get; set; }

        /// <summary>
        /// Gets or sets the foc quantity.
        /// </summary>
        /// <value>
        /// The foc quantity.
        /// </value>
        public int FOCQuantity { get; set; }
    }
}
