﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The Id Proof Identifier
    /// </summary>
#pragma warning disable S101 // Types should be named in PascalCase
    public class IdProof
#pragma warning restore S101 // Types should be named in PascalCase
    {
        /// <summary>
        /// Gets or sets the Id proof  identifier.
        /// </summary>
        /// <value>
        /// The Id proof identifier.
        /// </value>
        [Key, Identity]
        public int IdProofId { get; set; }

        /// <summary>
        /// Gets or sets the name of the HWC.
        /// </summary>
        /// <value>
        /// The name of the HWC.
        /// </value>
        public string IdProofName { get; set; } 
        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="IdProof"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

    }
}
