﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The lab detail.
    /// </summary>
    public class LabDetail
    {
        /// <summary>
        /// Gets or sets the lab detail id.
        /// </summary>
        [Key, Identity]
        public int LabDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the test parameter.
        /// </summary>
        public string TestParameter { get; set; }

        /// <summary>
        /// Gets or sets the reference range.
        /// </summary>
        public string ReferenceRange { get; set; }

        /// <summary>
        /// Gets or sets the refrence range unit.
        /// </summary>
        public int? RefrenceRangeUnit { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }
    }
}
