﻿namespace Hims.Domain.Entities.Labs
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    public class LabComponentDetail
    {
        /// <summary>
        /// Gets or sets the lab component detail identifier.
        /// </summary>
        /// <value>
        /// The lab component detail identifier.
        /// </value>
        [Key, Identity]
        public int LabComponentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab component header identifier.
        /// </summary>
        /// <value>
        /// The lab component header identifier.
        /// </value>
        public int LabComponentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>
        public int LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int Priority { get; set; }
    }
}
