﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The Menu
    /// </summary>
    public class Menu
    {
        /// <summary>
        /// Gets or sets the menu identifier.
        /// </summary>
        /// <value>
        /// The menu identifier.
        /// </value>
        [Key, Identity]
        public int MenuId { get; set; }

        /// <summary>
        /// Gets or sets the main page.
        /// </summary>
        /// <value>
        /// The main page.
        /// </value>
        public string MainPage { get; set; }

        /// <summary>
        /// Gets or sets the sub page.
        /// </summary>
        /// <value>
        /// The sub page.
        /// </value>
        public string SubPage { get; set; }

        /// <summary>
        /// Gets or sets the category.
        /// </summary>
        /// <value>
        /// The category.
        /// </value>
        public string Category { get; set; }

        /// <summary>
        /// Gets or sets the URL.
        /// </summary>
        /// <value>
        /// The URL.
        /// </value>
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the count.
        /// </summary>
        /// <value>
        /// The count.
        /// </value>
        public int Count { get; set; }

        /// <summary>
        /// Gets or sets the general classes.
        /// </summary>
        /// <value>
        /// The general classes.
        /// </value>
        public string GeneralClasses { get; set; }

        /// <summary>
        /// Gets or sets the icon classes.
        /// </summary>
        /// <value>
        /// The icon classes.
        /// </value>
        public string IconClasses { get; set; }

        /// <summary>
        /// Gets or sets the menu type identifier.
        /// </summary>
        /// <value>
        /// The menu type identifier.
        /// </value>
        public int? MenuTypeId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int? Priority { get; set; }
        /// <summary>
        /// Gets or sets the encounter key.
        /// </summary>
        /// <value>
        /// The encounter key.
        /// </value>
        public string? EncounterKey { get; set; }


    }
}
