﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The patient.
    /// </summary>
    public class Patient
    {
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        [Key, Identity]
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the City.
        /// </summary>
        public string? City { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? Salutation { get; set; }

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the middle name.
        /// </summary>
        public string? MiddleName { get; set; }

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the father or husband.
        /// </summary>
        public string FatherOrHusband { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the aadhar no.
        /// </summary>
        public string? AadharNo { get; set; }
        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public short? Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the marital status.
        /// </summary>
        public char? MaritalStatus { get; set; }

        /// <summary>
        /// Gets or sets the umr.
        /// </summary>
        //[IgnoreUpdate]
        public string UMRNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; }

        /// <summary>
        /// Gets or sets the street address.
        /// </summary>
        public string? StreetAddress { get; set; }

        /// <summary>
        /// Gets or sets the address line 2.
        /// </summary>
        public string? AddressLine2 { get; set; }

        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        public string? State { get; set; }

        /// <summary>
        /// Gets or sets the Zipcode.
        /// </summary>
        public string? Zipcode { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the profile image url.
        /// </summary>
        public string? ProfileImageUrl { get; set; }

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the guid.
        /// </summary>
        [IgnoreUpdate]
        public Guid Guid { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the Referral Code.
        /// </summary>
        public string? ReferralCode { get; set; }

        /// <summary>
        /// Gets or sets the Referral by id.
        /// </summary>
        public int? ReferralBy { get; set; }

        /// <summary>
        /// Gets or sets the Referred by.
        /// </summary>
        public string? ReferredBy { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? ReferredByName { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the HWC patient identifier.
        /// </summary>
        /// <value>
        /// The HWC patient identifier.
        /// </value>
        public int? HWCPatientId { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Education { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Occupation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Nationality { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Religion { get; set; }
        // <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public int? PatientReferredById { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? IdProofId { get; set; }

        /// <summary>
        /// Gets or sets the id proof value.
        /// </summary>
        public string? IdProofValue { get; set; }

        /// <summary>
        /// Gets or sets the Blood Group value.
        /// </summary>
        public string? BloodGroup { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? PaymentStatus { get; set; }

        /// <summary>
        ///  Gets or sets payment number.
        /// </summary>
        public string? PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the Pay type id from payType masters.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? Amount { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? TempPatient { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? HowDidYouKnowId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? EducationId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? OccupationId { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? BirthMark1 { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? BirthMark2 { get; set; }


        /// <summary>
        /// Gets or sets the type of the relation.
        /// </summary>
        /// <value>
        /// The type of the relation.
        /// </value>
        public string? RelationType { get; set; }

        /// <summary>
        /// Gets or sets the occupation detail.
        /// </summary>
        /// <value>
        /// The occupation detail.
        /// </value>
        public string? OccupationDetail { get; set; }
        /// <summary>
        /// Gets or sets the is new patient.
        /// </summary>
        /// <value>
        /// The is new patient.
        /// </value>
        public bool IsNewPatient { get; set; }
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        /// <value>
        /// The appointment id.
        /// </value>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
        public int? InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ReferredByNameId { get; set; }

        /// <summary>
        /// Gets or sets the REG NO .
        /// </summary>
        /// <value>
        /// The occupation detail.
        /// </value>
        public string? REGNO { get; set; }

        /// <summary>
        /// Get or sets the total.
        /// </summary>
        public decimal? Total { get; set; }

        /// <summary>
        /// Get or sets the total.
        /// </summary>
        public decimal? DiscountInPercentage { get; set; }

        /// <summary>
        /// Get or sets the total.
        /// </summary>
        public decimal? DiscountInRupees { get; set; }
        public bool IsBabyRegistration { get; set; }
        public int? ParentPatientId { get; set; }
        public TimeSpan? TimeOfBirth { get; set; }
    }
}
