﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class ScanTestMaster
    {
        /// <summary>
        /// Gets or sets the scan test master id.
        /// </summary>
        [Key, Identity]
        public int ScanTestMasterId { get; set; }

        /// <summary>
        /// Gets or sets the scan test name.
        /// </summary>
        public string ScanTestName { get; set; }

        /// <summary>
        /// Gets or sets the scan test code.
        /// </summary>
        public string ScanTestCode { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public decimal Duration { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the Scan Sub Classification Id.
        /// </summary>
        public int? ScanSubClassificationId { get; set; }

        /// <summary>
        /// Gets or sets the test sub category.
        /// </summary>
        public int? ScanClassificationId { get; set; }      

        /// <summary>
        /// Gets or sets the module master identifier.
        /// </summary>
        /// <value>
        /// The module master identifier.
        /// </value>
        [IgnoreUpdate]
        public int ModulesMasterId { get; set; }
    }
}