﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The support category.
    /// </summary>
    public class SupportCategory
    {
        /// <summary>
        /// Gets or sets the support category id.
        /// </summary>
        [Key, Identity]
        public int SupportCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the issue with.
        /// </summary>
        public string IssueWith { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the is show to existing.
        /// </summary>
        public bool? IsShowToExisting { get; set; }
    }
}
